<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Segment extends Model 
{

    protected $table = 'segments';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function contacts()
    {
        return $this->belongsToMany('ContactSegment');
    }

    public function criterion()
    {
        return $this->hasOne('Criterion');
    }

}